------------------------------------------------------------------------------------------
--
--	Glob_Var
--	========
--
--	Author: Ganesh Thadkamalla, Joseph Wilson 
--	Creation Date: 
--
--	Last Revised Date:  12/25/2006
--
--	Copyright (C) Oracle Services
--
--Description:  Global variables.  Added variables required for batch processing. --GT.
-- comments: set online limits to 0.  -GT.
--
------------------------------------------------------------------------------------------

create or replace package DW_glob_var IS
type ident_arr100 is table of varchar2(100) index by binary_integer;
empty  owa_util.ident_arr; 
empty100 ident_arr100;
/****************************************************************************
 The following serve as examples for the variables that need to be set for specific environment.
  lv_program_path varchar2(1000):= URL for web procedures.  Example: 'http://'||owa_util.get_cgi_env('SERVER_NAME')||owa_util.get_owa_service_path;
  lv_script_path varchar2(1000):= URL for storet.js, a javascript file. Example: 'http://everest.sdc-moses.com/storet/modern/scripts/storet.js';
  lv_image_path varchar2(1000):= URL for storet image files. Example: 'http://everest.sdc-moses.com/storet/modern/images/';
  lv_doc_path varchar2(1000):= URL for static html documents.  Example: 'http://everest.sdc-moses.com/storet/modern/doc/';
--file io directory for downloads
  lv_iodir varchar2(100):= physical directory path used for utl_file parameter.  Example: '/project/storet/modern/downloads';
  lv_download_path varchar2(200):= URL for above directory.  Example: 'http://everest.sdc-moses.com/storet/modern/downloads/';
--Report server path with key
  lv_report_key varchar2(200):= Report server URL and key. Example: 'http://everest.sdc-moses.com/storet/cgi-bin/rwcgi60s?storetmod';
-- where rwcgi60s is a shell script that sets cgi environment variables and calls Oracle's rwcgi60 executable.  storetmod is an entry in key mapping file. this key should have server=reportserver_name userid=storet_reports_username/password@connectstring %
*****************************************************************************/
--SDC UNIX everest/olympus paths.
  lv_program_path CONSTANT VARCHAR2(1000):= 'http://oasdev.sdc-moses.com/storet/srdev/';
--SDC environment path variables
  lv_script_path constant varchar2(1000):= 'http://everest.sdc-moses.com/storet/moderndev/scripts/DW_storet.js';
  lv_image_path constant varchar2(1000):= 'http://everest.sdc-moses.com/storet/moderndev/images/';
  lv_doc_path constant varchar2(1000):= 'http://everest.sdc-moses.com/storet/moderndev/doc/';
--file io directory for downloads
  lv_iodir constant varchar2(100):='/project/storet/moderndev/downloads';
  lv_download_path constant varchar2(200):= 'http://everest.sdc-moses.com/storet/moderndev/downloads/';

-- Simple Mail Transfer Protocal informatioin.
smtp_host CONSTANT VARCHAR2(200):= 'olympus.sdc-moses.com';
smtp_port CONSTANT NUMBER :=25;

--Batch processing global variables.
-- Station variables.  

GV_STN_Immediate_LMT constant  number := 60000;
gv_stn_Overnight_lmt constant  number := 80000;
-- result variables.

gv_rslt_Immediate_lmt constant number := 90000;
gv_rslt_Overnight_lmt constant number := 120000;


gv_cmprs_fl_ext constant varchar2(3) :='gz';

--enter hour of the day in 24 hr format for running overnight batch jobs. (example: 20 for 8:00 PM)
gv_overnight_hour constant number:=20;

-- Time for checking Batch process Pending requests in 24 hr format. (example: 6.00 for 6:00 AM)
gv_pending_report_hr constant number:= 6.00;

gv_STORET_email constant varchar2(50):= 'storet@epa.gov';

-- Determines how many projects will be listed for National Project selection in dw_proj_popup.
national_project_criteria CONSTANT NUMBER:=4;

--Do Not change the following limits.  This will allow online downloads.  The online part of the application code is not updated for the enhancements. Attention: This can break the application.
gv_rslt_online_lmt constant number := 0;
gv_stn_online_lmt constant  number := 0;

end; 
/
